/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.fan;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.components.fan.AirCurrentSound;
import com.simibubi.create.content.contraptions.components.fan.EncasedFanTileEntity;
import com.simibubi.create.content.contraptions.components.fan.IAirCurrentSource;
import com.simibubi.create.content.contraptions.particle.AirFlowParticleData;
import com.simibubi.create.content.contraptions.processing.InWorldProcessing;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;

public class AirCurrent {
    public final IAirCurrentSource source;
    public AABB bounds = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public List<AirCurrentSegment> segments = new ArrayList<AirCurrentSegment>();
    public Direction direction;
    public boolean pushing;
    public float maxDistance;
    protected List<Pair<TransportedItemStackHandlerBehaviour, InWorldProcessing.Type>> affectedItemHandlers = new ArrayList<Pair<TransportedItemStackHandlerBehaviour, InWorldProcessing.Type>>();
    protected List<Entity> caughtEntities = new ArrayList<Entity>();
    static boolean isClientPlayerInAirCurrent;
    @OnlyIn(value=Dist.CLIENT)
    static AirCurrentSound flyingSound;

    public AirCurrent(IAirCurrentSource source) {
        this.source = source;
    }

    public void tick() {
        if (this.direction == null) {
            this.rebuild();
        }
        Level world = this.source.getAirCurrentWorld();
        Direction facing = this.direction;
        if (world != null && world.f_46443_) {
            float offset = this.pushing ? 0.5f : this.maxDistance + 0.5f;
            Vec3 pos = VecHelper.getCenterOf((Vec3i)this.source.getAirCurrentPos()).m_82549_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_((double)offset));
            if ((double)world.f_46441_.nextFloat() < (Double)AllConfigs.CLIENT.fanParticleDensity.get()) {
                world.m_7106_((ParticleOptions)new AirFlowParticleData((Vec3i)this.source.getAirCurrentPos()), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
            }
        }
        this.tickAffectedEntities(world, facing);
        this.tickAffectedHandlers();
    }

    protected void tickAffectedEntities(Level world, Direction facing) {
        Iterator<Entity> iterator = this.caughtEntities.iterator();
        while (iterator.hasNext()) {
            InWorldProcessing.Type processingType;
            Entity entity = iterator.next();
            if (!entity.m_6084_() || !entity.m_142469_().m_82381_(this.bounds) || AirCurrent.isPlayerCreativeFlying(entity)) {
                iterator.remove();
                continue;
            }
            Vec3 center = VecHelper.getCenterOf((Vec3i)this.source.getAirCurrentPos());
            Vec3i flow = (this.pushing ? facing : facing.m_122424_()).m_122436_();
            float sneakModifier = entity.m_6144_() ? 4096.0f : 512.0f;
            float speed = Math.abs(this.source.getSpeed());
            double entityDistance = entity.m_20182_().m_82554_(center);
            float acceleration = (float)((double)(speed / sneakModifier) / (entityDistance / (double)this.maxDistance));
            Vec3 previousMotion = entity.m_20184_();
            float maxAcceleration = 5.0f;
            double xIn = Mth.m_14008_((double)((double)((float)flow.m_123341_() * acceleration) - previousMotion.f_82479_), (double)(-maxAcceleration), (double)maxAcceleration);
            double yIn = Mth.m_14008_((double)((double)((float)flow.m_123342_() * acceleration) - previousMotion.f_82480_), (double)(-maxAcceleration), (double)maxAcceleration);
            double zIn = Mth.m_14008_((double)((double)((float)flow.m_123343_() * acceleration) - previousMotion.f_82481_), (double)(-maxAcceleration), (double)maxAcceleration);
            entity.m_20256_(previousMotion.m_82549_(new Vec3(xIn, yIn, zIn).m_82490_(0.125)));
            entity.f_19789_ = 0.0f;
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> AirCurrent.enableClientPlayerSound(entity, Mth.m_14036_((float)(speed / 128.0f * 0.4f), (float)0.01f, (float)0.4f)));
            if (entity instanceof ServerPlayer) {
                ((ServerPlayer)entity).f_8906_.f_9737_ = 0;
            }
            if ((processingType = this.getSegmentAt((float)(entityDistance -= 0.5))) == null || processingType == InWorldProcessing.Type.NONE) continue;
            if (entity instanceof ItemEntity) {
                IAirCurrentSource iAirCurrentSource;
                ItemEntity itemEntity = (ItemEntity)entity;
                if (world.f_46443_) {
                    processingType.spawnParticlesForProcessing(world, entity.m_20182_());
                    continue;
                }
                if (!InWorldProcessing.canProcess(itemEntity, processingType) || !InWorldProcessing.applyProcessing(itemEntity, processingType) || !((iAirCurrentSource = this.source) instanceof EncasedFanTileEntity)) continue;
                EncasedFanTileEntity fan = (EncasedFanTileEntity)iAirCurrentSource;
                fan.award(AllAdvancements.FAN_PROCESSING);
                continue;
            }
            processingType.affectEntity(entity, world);
        }
    }

    public void rebuild() {
        if (this.source.getSpeed() == 0.0f) {
            this.maxDistance = 0.0f;
            this.segments.clear();
            this.bounds = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            return;
        }
        this.direction = this.source.getAirflowOriginSide();
        this.pushing = this.source.getAirFlowDirection() == this.direction;
        this.maxDistance = this.source.getMaxDistance();
        Level world = this.source.getAirCurrentWorld();
        BlockPos start = this.source.getAirCurrentPos();
        float max = this.maxDistance;
        Direction facing = this.direction;
        Vec3 directionVec = Vec3.m_82528_((Vec3i)facing.m_122436_());
        this.maxDistance = AirCurrent.getFlowLimit(world, start, max, facing);
        AirCurrentSegment currentSegment = new AirCurrentSegment();
        this.segments.clear();
        currentSegment.startOffset = 0;
        InWorldProcessing.Type type = InWorldProcessing.Type.NONE;
        int limit = (int)(this.maxDistance + 0.5f);
        int searchStart = this.pushing ? 0 : limit;
        int searchEnd = this.pushing ? limit : 0;
        int searchStep = this.pushing ? 1 : -1;
        int i = searchStart;
        while (i * searchStep <= searchEnd * searchStep) {
            BlockPos currentPos = start.m_5484_(this.direction, i);
            InWorldProcessing.Type newType = InWorldProcessing.Type.byBlock((BlockGetter)world, currentPos);
            if (newType != InWorldProcessing.Type.NONE) {
                type = newType;
            }
            if (currentSegment.type != type || currentSegment.startOffset == 0) {
                currentSegment.endOffset = i;
                if (currentSegment.startOffset != 0) {
                    this.segments.add(currentSegment);
                }
                currentSegment = new AirCurrentSegment();
                currentSegment.startOffset = i;
                currentSegment.type = type;
            }
            i += searchStep;
        }
        currentSegment.endOffset = searchEnd + searchStep;
        this.segments.add(currentSegment);
        if (this.maxDistance < 0.25f) {
            this.bounds = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        } else {
            float factor = this.maxDistance - 1.0f;
            Vec3 scale = directionVec.m_82490_((double)factor);
            this.bounds = factor > 0.0f ? new AABB(start.m_142300_(this.direction)).m_82369_(scale) : new AABB(start.m_142300_(this.direction)).m_82310_(scale.f_82479_, scale.f_82480_, scale.f_82481_).m_82383_(scale);
        }
        this.findAffectedHandlers();
    }

    public static float getFlowLimit(Level world, BlockPos start, float max, Direction facing) {
        BlockPos currentPos;
        Vec3 directionVec = Vec3.m_82528_((Vec3i)facing.m_122436_());
        Vec3 planeVec = VecHelper.axisAlingedPlaneOf(directionVec);
        float offsetDistance = 0.25f;
        Vec3[] offsets = new Vec3[]{planeVec.m_82542_((double)offsetDistance, (double)offsetDistance, (double)offsetDistance), planeVec.m_82542_((double)(-offsetDistance), (double)(-offsetDistance), (double)offsetDistance), planeVec.m_82542_((double)offsetDistance, (double)(-offsetDistance), (double)(-offsetDistance)), planeVec.m_82542_((double)(-offsetDistance), (double)offsetDistance, (double)(-offsetDistance))};
        float limitedDistance = 0.0f;
        int i = 1;
        while ((float)i <= max && world.m_46749_(currentPos = start.m_5484_(facing, i))) {
            block5: {
                VoxelShape voxelshape;
                BlockState state = world.m_8055_(currentPos);
                if (!AirCurrent.shouldAlwaysPass(state) && !(voxelshape = state.m_60742_((BlockGetter)world, currentPos, CollisionContext.m_82749_())).m_83281_()) {
                    if (voxelshape == Shapes.m_83144_()) {
                        max = i - 1;
                        break;
                    }
                    for (Vec3 offset : offsets) {
                        Vec3 rayEnd;
                        Vec3 rayStart = VecHelper.getCenterOf((Vec3i)currentPos).m_82546_(directionVec.m_82490_(0.53125)).m_82549_(offset);
                        BlockHitResult blockraytraceresult = world.m_45558_(rayStart, rayEnd = rayStart.m_82549_(directionVec.m_82490_(1.03125)), currentPos, voxelshape, state);
                        if (blockraytraceresult != null) {
                            double distance = (double)(i - 1) + blockraytraceresult.m_82450_().m_82554_(rayStart);
                            if (!((double)limitedDistance < distance)) continue;
                            limitedDistance = (float)distance;
                            continue;
                        }
                        break block5;
                    }
                    max = limitedDistance;
                    break;
                }
            }
            ++i;
        }
        return max;
    }

    public void findEntities() {
        this.caughtEntities.clear();
        this.caughtEntities = this.source.getAirCurrentWorld().m_45933_(null, this.bounds);
    }

    public void findAffectedHandlers() {
        Level world = this.source.getAirCurrentWorld();
        BlockPos start = this.source.getAirCurrentPos();
        this.affectedItemHandlers.clear();
        int i = 0;
        while ((float)i < this.maxDistance + 1.0f) {
            InWorldProcessing.Type type = this.getSegmentAt(i);
            if (type != null) {
                for (int offset : Iterate.zeroAndOne) {
                    BlockPos pos = start.m_5484_(this.direction, i).m_6625_(offset);
                    TransportedItemStackHandlerBehaviour behaviour = TileEntityBehaviour.get((BlockGetter)world, pos, TransportedItemStackHandlerBehaviour.TYPE);
                    if (behaviour != null) {
                        this.affectedItemHandlers.add((Pair<TransportedItemStackHandlerBehaviour, InWorldProcessing.Type>)Pair.of((Object)behaviour, (Object)((Object)type)));
                    }
                    if (this.direction.m_122434_().m_122478_()) break;
                }
            }
            ++i;
        }
    }

    public void tickAffectedHandlers() {
        for (Pair<TransportedItemStackHandlerBehaviour, InWorldProcessing.Type> pair : this.affectedItemHandlers) {
            TransportedItemStackHandlerBehaviour handler = (TransportedItemStackHandlerBehaviour)pair.getKey();
            Level world = handler.getWorld();
            InWorldProcessing.Type processingType = (InWorldProcessing.Type)((Object)pair.getRight());
            handler.handleProcessingOnAllItems(transported -> {
                IAirCurrentSource patt10979$temp;
                if (world.f_46443_) {
                    if (world != null) {
                        processingType.spawnParticlesForProcessing(world, handler.getWorldPositionOf((TransportedItemStack)transported));
                    }
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                }
                TransportedItemStackHandlerBehaviour.TransportedResult applyProcessing = InWorldProcessing.applyProcessing(transported, world, processingType);
                if (!applyProcessing.doesNothing() && (patt10979$temp = this.source) instanceof EncasedFanTileEntity) {
                    EncasedFanTileEntity fan = (EncasedFanTileEntity)patt10979$temp;
                    fan.award(AllAdvancements.FAN_PROCESSING);
                }
                return applyProcessing;
            });
        }
    }

    private static boolean shouldAlwaysPass(BlockState state) {
        return AllTags.AllBlockTags.FAN_TRANSPARENT.matches(state);
    }

    public InWorldProcessing.Type getSegmentAt(float offset) {
        for (AirCurrentSegment airCurrentSegment : this.segments) {
            if (offset > (float)airCurrentSegment.endOffset && this.pushing || offset < (float)airCurrentSegment.endOffset && !this.pushing) continue;
            return airCurrentSegment.type;
        }
        return InWorldProcessing.Type.NONE;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void enableClientPlayerSound(Entity e, float maxVolume) {
        if (e != Minecraft.m_91087_().m_91288_()) {
            return;
        }
        isClientPlayerInAirCurrent = true;
        float pitch = (float)Mth.m_14008_((double)(e.m_20184_().m_82553_() * 0.5), (double)0.5, (double)2.0);
        if (flyingSound == null || flyingSound.m_7801_()) {
            flyingSound = new AirCurrentSound(SoundEvents.f_11886_, pitch);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)flyingSound);
        }
        flyingSound.setPitch(pitch);
        flyingSound.fadeIn(maxVolume);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void tickClientPlayerSounds() {
        if (!isClientPlayerInAirCurrent && flyingSound != null) {
            if (flyingSound.isFaded()) {
                flyingSound.stopSound();
            } else {
                flyingSound.fadeOut();
            }
        }
        isClientPlayerInAirCurrent = false;
    }

    public static boolean isPlayerCreativeFlying(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.m_7500_() && player.m_150110_().f_35935_;
        }
        return false;
    }

    public static class AirCurrentSegment {
        InWorldProcessing.Type type;
        int startOffset;
        int endOffset;
    }
}

